function [filtered]=gaussfilterdata(mzaxis,dataraw,sigma,pixelnum);
%This program will filter your data using the gaussian filter algorithms.  
%A plot will be generated that shows the original data in blue and your 
%filtered data in red for a specific maldi imaging pixel. This approach was
%adapted from that used in capillary electrophoresis analysis as in K. C. 
%Waldron and N. J. Dovichi, Anal. Chem., 1992, 64, 1396-1399.


%INPUTS
%mzaxis - this is your m/z axis of the data.  If you trimmed your data, 
%then this input would be corresponding mass axis.

%dataraw - this is a matrix of your raw mz spectra.  These raw
%spectra may be trimmed.

%gaussianfilter - this is a number that sets the width of the gaussian
%smoothing.  The higher the number, the higher the smooth.  3-5 is a good
%ball park number to start with, but it depends on how many points are in
%your spectra. As expected in convolution, this smoothing will decrease the
%amplitude of sharp peaks the higher the smooth so there is a balance
%between noise removal and amplitude suppression.

%pixelnum - this is a number that refers to a specific pixel you wish to
%plot the mass spectrum of when looking at your data.  Any pixel number
%will work.  If you happen to know the row number of a good spectrum, use
%this.  If not, choose a random pixel number.


%OUTPUTS
%filtered - this is a matrix of your smoothed data. Each row is a mz 
%spectrum and each column is a specific mass to charge ratio.

%These commands generate a Gaussian function with unit area:
SmoothWidth = round(sigma*8+4);  
dummy = -(SmoothWidth)/2:1:(SmoothWidth)/2;
argument= -0.5*(dummy/sigma).^2;
gaus= exp(argument);
gaus=gaus/sum(gaus);

[aa,bb]=size(dataraw);
%the following commands perform the Gaussian filtering.  Excess points at
%the beginning and end created by the convolution process and as such need
%to be removed.
for x=1:aa
    data=dataraw(x,:);
    data=data';
    for count=1:size(data,2)
        smoothed(:,count) = conv(gaus,data(:,count));
    end
    SizeGain=length(smoothed)-length(data);
    smoothed(length(smoothed)-floor(0.5*SizeGain):length(smoothed),:)=[];
    smoothed(1:ceil(0.5*SizeGain)-1,:)=[];
    filtered(x,:)=smoothed';
    clear smoothed data
end
%These commands plot the before processing and after processing traces in
%blue and red, respectively.
figure
plot(mzaxis,dataraw(pixelnum,:),'LineWidth',2)
hold
plot(mzaxis,filtered(pixelnum,:),'r','LineWidth',2)
legend('Original','Smoothed')
set(gca,'FontSize',16)
set(gcf, 'color', 'white');
xlabel('Mass to Charge Ratio (m/z)','FontSize',16)
ylabel('Intensity','FontSize',16)